/** 
 * 
 * @author Joan Alba Maldonado
 */ 

package gui;

import java.awt.Graphics;
import java.awt.Color;
import java.awt.Font;

import logica.*;

//import java.awt.image.BufferedImage;
import principal.Main;

import configuracion.Idiomas;

//import gui.TetrisForm; //BORRAR!!!

//ACORDARSE de kitar todos los imports de Graphics en los demas sitios!!!

//Sugerencia: el metodo dibujarTexto() se podria mejorar interpretando los \t (tabuladores).

//FALTA: hacer un clearRect en todos los metodos de dibujo, para asi respetar transparencias a lo largo de los ciclos (bueno, en verdad deberia ser un rektangulo del kolor de fondo del tablero o del panel, k suele ser el vacio).

//FALTA: definir un kolor de fondo para la ventana/applet en general. solo ira si se hace un clearRect al menos la primera vez (o siempre k se resizee el juego/tablero/ventana).

public class MotorGrafico
{
    //Grafico que guarda lo que hay en pantalla:
    static protected int[][] graficoBackup = new int[Byte.MAX_VALUE][Byte.MAX_VALUE]; //Se pone lo maximo que puede ocupar un dato de tipo byte, para que nunca se quede corto.
    
    static protected boolean graficoInicializado = false; //Define si el grafico de backup ha sido inicializado (si el tablero ha sido dibujado alguna vez).
    
    static protected final int numeroCodificacionPiezas = configuracion.Otros.getNumeroCodificacionPiezas();
    
    static protected byte celdaAncho = configuracion.Aspecto.getCeldaAncho();
    static protected byte celdaAlto = configuracion.Aspecto.getCeldaAlto();
    
    static protected final int VACIO = configuracion.Otros.getNumeroVacio(); //Numero que nos marca un vacio.
    
    //static protected Image dobleBuffer = new Image(1000, 1000);
    
    private MotorGrafico()
    {
    }

    static public void setCeldaAncho(byte celdaAncho)
    {
        MotorGrafico.celdaAncho = celdaAncho;
    }
    
    static public byte getCeldaAncho()
    {
        return MotorGrafico.celdaAncho;
    }

    static public void setCeldaAlto(byte celdaAlto)
    {
        MotorGrafico.celdaAlto = celdaAlto;
    }
    
    static public byte getCeldaAlto()
    {
        return MotorGrafico.celdaAlto;
    }
    
    //Dibuja un tablero, una pieza o el panel:
    static public void dibujar(Graphics g, Object objeto)
    {
        //if (objeto == null) { return; }
        if (objeto instanceof Pieza) { dibujarPieza(g, (Pieza) objeto); }
        else if (objeto instanceof Tablero) { dibujarTablero(g, (Tablero) objeto); }
        else if (objeto instanceof Panel) { dibujarPanel(g, (Panel) objeto); }
    }

    //Dibuja una pieza:
    static public void dibujarPieza(Graphics g, Pieza pieza)
    {
        Paleta paleta = pieza.getPaleta();
        byte x = pieza.getLeft();
        byte y = pieza.getTop();
        byte ancho = pieza.getAncho();
        byte alto = pieza.getAlto();
        int[][] matriz = pieza.getForma();

        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, false);
    }
    
    //Dibuja un tablero:
    static public void dibujarTablero(Graphics g, Tablero tablero)
    {
        //Si el tablero no ha sido dibujado antes, pone todo el grafico backup a -1 (para asegurarse de que se pinte):
        if (!MotorGrafico.graficoInicializado) { inicializarGraficoBackup(); MotorGrafico.graficoInicializado = true; }
        
        //PRUEBA:
        //g.clearRect(0, 0, Main.ventanaPrincipal.getPanelJuego().getWidth(), Main.ventanaPrincipal.getPanelJuego().getHeight());
        
        Paleta paleta = tablero.getPaleta();
        byte x = 0;
        byte y = 0;
        byte ancho = tablero.getAncho();
        byte alto = tablero.getAlto();
        int[][] matriz = tablero.getMapa();

        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
    }
    
    //Dibuja un panel:
    static public void dibujarPanel(Graphics g, Panel panel)
    {
        Paleta paleta = panel.getPaleta();
        byte x = panel.getLeft();
        byte y = panel.getTop();
        byte ancho = panel.getAncho();
        byte alto = panel.getAlto();
        int[][] matriz = panel.getMapa();
        
        MotorGrafico.dibujarMatriz(g, paleta, matriz, x, y, ancho, alto, true);
        
        //Muestra tambien la informacion del panel:
        dibujarPanelInformacion(g, panel);
    }
    
    //Dibuja la informacion del panel:
    static protected void dibujarPanelInformacion(Graphics g, Panel panel)
    {
        int nivel = panel.getNivel();
        int puntos = panel.getPuntos();
        int lineas = panel.getLineas();
        int lineasNivel = panel.getLineasNivel();
        
        int x = panel.getLeft() * MotorGrafico.getCeldaAncho();
        int y = (panel.getTop() + panel.getAlto() + panel.getMargen()) * MotorGrafico.getCeldaAlto() + configuracion.Aspecto.getEspacioLineasTexto();
 
        //Borra el texto anterior, por si quedaba en pantalla:
        g.clearRect(x, y - configuracion.Aspecto.getEspacioLineasTexto(), 400, configuracion.Aspecto.getEspacioLineasTexto() * 5);
        
        //Pone el texto:
        Color colorTexto = panel.getPaleta().getColor(panel.getColorTexto());
        Font fuenteTexto = new Font(Font.SANS_SERIF, Font.PLAIN, configuracion.Aspecto.getDimensionTexto());
        g.setColor(colorTexto);
        g.setFont(fuenteTexto);
        //g.drawString(configuracion.Idiomas.nivel[principal.Main.getIdiomaActual()] + ": " + nivel, x, y); y += configuracion.Aspecto.getEspacioLineasTexto();
        //g.drawString(configuracion.Idiomas.puntuacion[principal.Main.getIdiomaActual()] + ": " + puntos, x, y); y += configuracion.Aspecto.getEspacioLineasTexto();
        //g.drawString(configuracion.Idiomas.lineasTotales[principal.Main.getIdiomaActual()] + ": " + lineas, x, y); y += configuracion.Aspecto.getEspacioLineasTexto();
        //g.drawString(configuracion.Idiomas.lineasNivel[principal.Main.getIdiomaActual()] + ": " + lineasNivel, x, y); y += configuracion.Aspecto.getEspacioLineasTexto();
        //CAMBIADO:
        MotorGrafico.dibujarTexto(g, configuracion.Idiomas.nivel[principal.Main.getIdiomaActual()] + ": " + nivel, x, y, configuracion.Aspecto.getEspacioLineasTexto()); y += configuracion.Aspecto.getEspacioLineasTexto();
        MotorGrafico.dibujarTexto(g, configuracion.Idiomas.puntuacion[principal.Main.getIdiomaActual()] + ": " + puntos, x, y, configuracion.Aspecto.getEspacioLineasTexto()); y += configuracion.Aspecto.getEspacioLineasTexto();
        MotorGrafico.dibujarTexto(g, configuracion.Idiomas.lineasTotales[principal.Main.getIdiomaActual()] + ": " + lineas, x, y, configuracion.Aspecto.getEspacioLineasTexto()); y += configuracion.Aspecto.getEspacioLineasTexto();
        MotorGrafico.dibujarTexto(g, configuracion.Idiomas.lineasNivel[principal.Main.getIdiomaActual()] + ": " + lineasNivel, x, y, configuracion.Aspecto.getEspacioLineasTexto()); y += configuracion.Aspecto.getEspacioLineasTexto();
    }
    
    //Dibuja un menu:
    static public void dibujarMenu(Graphics g, Menu menu)
    {
        //FALTA: color de fondo y dibujo de la opcion aktual.
        String[] opciones = menu.getOpciones();
        
        Color colorTexto = menu.getPaleta().getColor(menu.getColorTexto());
        Color colorTextoFijo = menu.getPaleta().getColor(menu.getColorTextoFijo());
        Color colorTextoFondo = menu.getPaleta().getColor(menu.getColorTextoFondo());
        Color colorTextoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoSeleccionado());
        Color colorTextoFondoSeleccionado = menu.getPaleta().getColor(menu.getColorTextoFondoSeleccionado());
        Color colorTextoAlternativo = menu.getPaleta().getColor(menu.getColorTextoAlternativo());
        Color colorTextoFondoAlternativo = menu.getPaleta().getColor(menu.getColorTextoFondoAlternativo());

        Font fuenteTexto = new Font(Font.SANS_SERIF, Font.PLAIN, configuracion.Aspecto.getDimensionTexto());
        g.setFont(fuenteTexto);

        //Pone el texto permanente:
        g.setColor(colorTextoFijo);
        MotorGrafico.dibujarTexto(g, menu.getTextoFijo(), menu.getTextoFijoLeft(), menu.getTextoFijoTop(), configuracion.Aspecto.getEspacioLineasTexto());
        //g.drawString(menu.getTextoFijo(), menu.getTextoFijoLeft(), menu.getTextoFijoTop());
        
        //Dibuja el logo:
        int[][] logo = menu.getLogo();
        MotorGrafico.dibujarMatriz(g, menu.getPaleta(), logo, menu.getLeftLogo(), menu.getTopLogo(), (byte) logo[0].length, (byte) logo.length, false);
        
        int top = menu.getTop();
        int left = menu.getLeft();
        
        //FALTA: si top y/o left son mas grandes que el graphics, ponerlo al maximo o donde se kiera poner.
        //Pone las opciones del menu y sus dibujos (si tienen):
        int[][] dibujo;
        for (int x = 0; x < opciones.length; x++)
        {
            //FALTA: color de fondo!!!!!

            //Si la opcion esta marcada, la marca con los colores pertinentes:
            if (x == menu.getOpcionActualIndice())
            {
                //Muestra su dibujo, si tiene:
                dibujo = menu.getDibujoActual();
                if (dibujo != null)
                {
                    MotorGrafico.dibujarMatriz(g, menu.getPaleta(), dibujo, menu.getLeftDibujoActual(), menu.getTopDibujoActual(), (byte) dibujo[0].length, (byte) dibujo.length, false);
                }
                //Pone el color para el texto de la opcion:
                g.setColor(colorTextoSeleccionado);
            }
            else { g.setColor(colorTexto); }

            MotorGrafico.dibujarTexto(g, opciones[x], left, top, configuracion.Aspecto.getEspacioLineasTexto());
            top += configuracion.Aspecto.getEspacioLineasTexto();
        }
        
        //Pone el texto alternativo actual (si hay):
        //FALTA: color de fondo!!!!!
        if (menu.getTextoAlternativoActual() != null)
        {
            if (menu.getTextoAlternativoActual().trim() != "")
            {
                g.setColor(colorTextoAlternativo);
                left = menu.getLeftTextoAlternativoActual();
                top = menu.getTopTextoAlternativoActual();
                //g.drawString(menu.getTextoAlternativoActual(), left, top); //CAMBIADO:
                MotorGrafico.dibujarTexto(g, menu.getTextoAlternativoActual(), left, top, configuracion.Aspecto.getEspacioLineasTexto());
            }
        }
    }

    //Dibuja un texto (teniendo en cuenta los saltos de linea), con un color:
    static public void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas, Color colorTexto)
    {
        g.setColor(colorTexto);
        MotorGrafico.dibujarTexto(g, texto, left, top, espacioEntreLineas);
    }
    
    //Dibuja un texto (teniendo en cuenta los saltos de linea):
    static public void dibujarTexto(Graphics g, String texto, int left, int top, int espacioEntreLineas)
    {
        String textoParcial;
        
        //texto.substring(0, texto.indexOf("\n"));
        
        int topActual = top;

        //Nota: se podria mejorar interpretando los \t (tabuladores).
        
        while (texto.trim().length() > 0)
        {
            if (texto.indexOf("\n") != -1) { textoParcial = texto.substring(0, texto.indexOf("\n")); }
            else { textoParcial = texto; }
            if (texto.indexOf("\n") != -1) { texto = texto.substring(texto.indexOf("\n") + 1); }
            else { texto = ""; }
            g.drawString(textoParcial, left, topActual);
            topActual += espacioEntreLineas;
        }
    }
    
    //Dibuja una matriz en una posicion inicial dada:
    static public void dibujarMatriz(Graphics g, Paleta paleta, int[][] matriz, byte left, byte top, byte ancho, byte alto, boolean dibujarVacios)
    {

        //BufferedImage imagenBuffer = new BufferedImage(Main.ventanaPrincipal.getPanelJuego().getWidth(), Main.ventanaPrincipal.getPanelJuego().getHeight(), BufferedImage.TYPE_4BYTE_ABGR_PRE);
        
        int indiceColor;
        byte x, y = top;
        for (byte f = 0; f < alto; f++)
        {
            x = left;
            for (byte c = 0; c < ancho; c++)
            {
                indiceColor = matriz[f][c];

                //Si es un vacio y se ha enviado no dibujarlos, pasa de loop:
                if (indiceColor == MotorGrafico.VACIO && !dibujarVacios) { x++; continue; }

                MotorGrafico.dibujarCasilla(g, paleta, indiceColor, x, y);
                //MotorGrafico.dibujarCasilla(imagenBuffer.getGraphics(), paleta, indiceColor, x, y);
                x++;
            }
            y++;
        }

        //g.drawImage(imagenBuffer, 0, 0, Main.ventanaPrincipal.getPanelJuego());
    }
    
    //Dibuja una casilla en una posicion dada:
    static protected void dibujarCasilla(Graphics g, Paleta paleta, int indiceColor, byte x, byte y)
    {
        //Si se ha enviado la x o la y negativas, sale de la funcion:
        if (x < 0 || y < 0) { return; }
        
        //Decodifica el color, si hace falta:
        if (indiceColor < 0) { indiceColor /= MotorGrafico.numeroCodificacionPiezas; }
        
        //Si la casilla que se va a pintar es igual a la que ya hay, no la pinta:
        //if (MotorGrafico.graficoBackup[x][y] == indiceColor) { return; } //<-- parece ser ke no va porke el metodo paint lo borra todo y deja el background!!!
        //else { MotorGrafico.actualizarGraficoBackup(indiceColor, x, y); } //Actualiza el grafico backup, para la proxima vez.
        MotorGrafico.actualizarGraficoBackup(indiceColor, x, y);

        //Pone el color que corresponde:
        Color color = paleta.getColor(indiceColor);
        g.setColor(color);

        //Coge el alto y ancho de la casilla definidos en la configuracion:
        int xReal = x * MotorGrafico.getCeldaAncho();
        int yReal = y * MotorGrafico.getCeldaAlto();
        g.fillRect(xReal, yReal, MotorGrafico.getCeldaAncho(), MotorGrafico.getCeldaAlto());
    }
    
    //Actualiza el grafico backup:
    static protected void actualizarGraficoBackup(int indiceColor, byte x, byte y)
    {
        //Si la casilla es diferente a la que habia antes, la guarda:
        if (MotorGrafico.graficoBackup[x][y] != indiceColor)
        {
            MotorGrafico.graficoBackup[x][y] = indiceColor;
        }
    }
    
    //Inicializa ("vacia") el grafico backup:
    static protected void inicializarGraficoBackup()
    {
        for (byte f = 0; f < MotorGrafico.graficoBackup.length; f++)
        {
            for (byte c = 0; c < MotorGrafico.graficoBackup[0].length; c++)
            {
                MotorGrafico.graficoBackup[f][c] = -1;
            }
        }
    }
}
